using System;
using System.Collections;

namespace examples {

  // System.Collections.ArrayList to be marshaled as java.util.Vector
  public sealed class ArrayListMashaledAsVector : ArrayList {
  
    public ArrayListMashaledAsVector() : base() {
    }

    public ArrayListMashaledAsVector(ICollection collection) : base(collection) {
    }

    public ArrayListMashaledAsVector(int capacity) : base(capacity) {
    }

  }

  public sealed class ArrayListMashaledAsVectorValueFactory : J2EE.Factories.VectorValueFactory {
    
    public override Type GetValueType() {
      return typeof(ArrayListMashaledAsVector);
    }

    public override ArrayList CreateObject() {
      return new ArrayListMashaledAsVector();
    }

  }

  // System.Collections.ArrayList to be marshaled as java.util.HashSet
  public sealed class ArrayListMashaledAsHashSet : ArrayList {
    
    public ArrayListMashaledAsHashSet() : base() {
    }

    public ArrayListMashaledAsHashSet(ICollection collection) : base(collection) {
    }

    public ArrayListMashaledAsHashSet(int capacity) : base(capacity) {
    }

  }

  public sealed class ArrayListMashaledAsHashSetValueFactory : J2EE.Factories.HashSetValueFactory {
    
    public override Type GetValueType() {
      return typeof(ArrayListMashaledAsHashSet);
    }

    public override ArrayList CreateObject() {
      return new ArrayListMashaledAsHashSet();
    }

  }

}
